'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/* --------------------------------------------------------------
	payone_checkout.js 2018-12-05
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2015 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
	--------------------------------------------------------------
*/

/**
 * Payone Checkout
 *
 * @module Widgets/payone_checkout
 */
gambio.widgets.module('payone_checkout', [], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        defaults = {},
        options = $.extend(true, {}, defaults, data),
        p1_debug = true,
        module = {};

    // ########## PAYONE FUNCTIONS ##########

    var _p1_payment_submit_handler = function _p1_payment_submit_handler(e) {
        var selected_payment = document.querySelector('#checkout_payment input[name="payment"]:checked').value;
        if (selected_payment === 'payone_cc') {
            if (p1_debug) {
                console.log('payone cc check triggered');
            }
            e.preventDefault();
            p1cc_check();
        }
    };

    var _initOnlineTransfer = function _initOnlineTransfer() {
        $('select#otrans_type').on('change', function (e) {
            var selected_type = $(this).val();
            var $pd_table = $(this).closest('table.payone_otrans_data');
            var $datarows = $('tr.datarow', $pd_table);
            $datarows.hide();
            $('.for_' + selected_type).show();
            if (selected_type == 'pfefinance' || selected_type == 'pfcard') {
                $(this).closest('div.payment_item').addClass('data_valid');
                $(this).closest('div.payment_item').click();
            }
        });
        $('select#otrans_type').trigger('change');

        var otrans_input_handler = function otrans_input_handler(e) {
            var any_empty = false;
            $('.payone_otrans_data input[type="text"]:visible').each(function () {
                if ($(this).val() === '') {
                    any_empty = true;
                }
            });
            if (any_empty === true) {
                $('table.payone_otrans_data').addClass('payone_data_missing');
            } else {
                $('table.payone_otrans_data').removeClass('payone_data_missing');
            }
            $(this).closest('div.payment_item').removeClass('data_valid');
        };

        $('.payone_otrans_data input[type="text"]').keyup(otrans_input_handler);
        $('.payone_otrans_data input[type="text"]').change(otrans_input_handler);
    };

    var _initELV = function _initELV() {
        $('table.payone_elv_data select[name="p1_elv_country"]').on('change', function (e) {
            var selected_iso_2 = $(this).val();
            var only_de_rows = $('tr.only_de', $(this).closest('table'));
            if (selected_iso_2 == 'DE') {
                only_de_rows.show('fast');
            } else {
                only_de_rows.hide('fast');
            }
        });
        $('table.payone_elv_data select[name="p1_elv_country"]').trigger('change');

        $('.sepadata input').on('change', function (e) {
            var sepadata = '';
            $('.sepadata input').each(function () {
                sepadata += $(this).val();
            });
            if (sepadata.length === 0) {
                $('tr.only_de input').removeAttr('disabled');
            } else {
                $('tr.only_de input').attr('disabled', 'disabled');
            }
        });

        $('.only_de input').on('change', function (e) {
            var accountdata = '';
            $('.only_de input').each(function () {
                accountdata += $(this).val();
            });
            if (accountdata.length === 0) {
                $('tr.sepadata input').removeAttr('disabled');
            } else {
                $('tr.sepadata input').attr('disabled', 'disabled');
            }
        });

        var pg_callback_elv = function pg_callback_elv(response) {
            if (p1_debug) {
                console.log(response);
            }
            var current_block = $('div.module_option_checked');
            if (!response || (typeof response === 'undefined' ? 'undefined' : _typeof(response)) != 'object' || response.status != 'VALID') {
                // error occurred
                var errormessage = p1_payment_error;
                if (typeof response.customermessage == 'string') {
                    errormessage = response.customermessage;
                }
                $('p.p1_error', current_block).html(errormessage);
                $('p.p1_error', current_block).show();
                current_block.closest('div.payment_item').removeClass('data_valid');
                current_block.get(0).scrollIntoView();
            } else {
                pg_callback_elv_none();
                $('form#checkout_payment').trigger('submit');
            }
        };

        var pg_callback_elv_none = function pg_callback_elv_none() {
            var $checked_payment = $('input[name="payment"]:checked');
            $('p.p1_error', $checked_payment.closest('div.payment_item')).hide();
            $('table.payone_elv_data').hide();
            $('div.p1_finaldata_elv').show();
            $('td.final_elv_country').html($('select#p1_elv_country option').filter(':selected').html());
            $('td.final_elv_accountnumber').html($('input#p1_elv_accountnumber').val());
            $('td.final_elv_bankcode').html($('input#p1_elv_bankcode').val());
            $('td.final_elv_iban').html($('input#p1_elv_iban').val());
            $('td.final_elv_bic').html($('input#p1_elv_bic').val());
            $checked_payment.closest('div.payment_item').addClass('data_valid');
            $('table.payone_elv_data').removeClass('payone_paydata');
        };

        var payone_elv_checkdata = function payone_elv_checkdata(e) {
            var input_bankcountry = $('select[name="p1_elv_country"] option').filter(':selected').val();
            var input_accountnumber = $('input[name="p1_elv_accountnumber"]', $this).val();
            var input_bankcode = $('input[name="p1_elv_bankcode"]', $this).val();
            var input_iban = $('input[name="p1_elv_iban"]', $this).val();
            var input_bic = $('input[name="p1_elv_bic"]', $this).val();

            if (p1_elv_checkmode == 'none') {
                pg_callback_elv_none();
            } else {
                e.preventDefault(); // prevent submit
                var pg_config = p1_elv_config;
                var pg = new PAYONE.Gateway(pg_config, pg_callback_elv);
                var data = {};
                if (input_iban.length > 0) {
                    data = {
                        iban: input_iban,
                        bic: input_bic,
                        bankcountry: input_bankcountry
                    };
                } else {
                    data = {
                        bankaccount: input_accountnumber,
                        bankcode: input_bankcode,
                        bankcountry: input_bankcountry
                    };
                }

                if (p1_debug) {
                    console.log(data);
                }
                pg.call(data);
            }
        };

        $('form#checkout_payment').on('submit', function (e) {
            var $checked_payment = $('input[name="payment"]:checked');
            if ($checked_payment.val() === 'payone_elv') {
                if ($checked_payment.closest('div.payment_item').hasClass('data_valid') === false) {
                    payone_elv_checkdata(e);
                }
            }
        });
    };

    var _initSafeInv = function _initSafeInv() {
        var _safeInvDisplayAgreement = function _safeInvDisplayAgreement() {
            var safeInvType = $('#p1_safeinv_type').val();
            $('tr.p1-safeinv-agreement').not('.p1-show-for-' + safeInvType).hide();
            $('tr.p1-show-for-' + safeInvType).show();
        };
        $('select[name="safeinv_type"]').on('change', _safeInvDisplayAgreement);
        _safeInvDisplayAgreement();
    };

    // ########## INITIALIZATION ##########

    /**
     * Initialize Module
     * @constructor
     */
    module.init = function (done) {
        if (p1_debug) {
            console.log('payone_checkout module initializing, submodule ' + options.module);
        }
        if (options.module == 'cc') {
            $('form#checkout_payment').on('submit', _p1_payment_submit_handler);
        }
        if (options.module == 'otrans') {
            _initOnlineTransfer();
        }
        if (options.module == 'elv') {
            _initELV();
        }
        if (options.module == 'safeinv') {
            _initSafeInv();
        }
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
